import { world, system, Direction } from '@minecraft/server'

const faceOffset = new Map([
    [Direction.East, { x: 1, y: 0, z: 0 }], [Direction.West, { x: -1, y: 0, z: 0 }],
    [Direction.Up, { x: 0, y: 1, z: 0 }], [Direction.Down, { x: 0, y: -1, z: 0 }],
    [Direction.South, { x: 0, y: 0, z: 1 }], [Direction.North, { x: 0, y: 0, z: -1 }],
])

world.beforeEvents.worldInitialize.subscribe(initEvent => {
    initEvent.blockTypeRegistry.registerCustomComponent('v360:multi_destroy', {
        onTick({ block }) {
            const { x, y, z } = block.location
            if (block.hasTag('v360:up') && block.below().isAir) {
                block.dimension.runCommand(`setblock ${x} ${y} ${z} air [] destroy`)
            }
            else if (block.hasTag('v360:down') && block.above().isAir) {
                block.dimension.runCommand(`setblock ${x} ${y} ${z} air [] destroy`)
            }
            else if (block.hasTag('v360:north') && block.south().isAir) {
                block.dimension.runCommand(`setblock ${x} ${y} ${z} air [] destroy`)
            }
            else if (block.hasTag('v360:south') && block.north().isAir) {
                block.dimension.runCommand(`setblock ${x} ${y} ${z} air [] destroy`)
            }
            else if (block.hasTag('v360:west') && block.east().isAir) {
                block.dimension.runCommand(`setblock ${x} ${y} ${z} air [] destroy`)
            }
            else if (block.hasTag('v360:east') && block.west().isAir) {
                block.dimension.runCommand(`setblock ${x} ${y} ${z} air [] destroy`)
            }
        },
        beforeOnPlayerPlace: (event) => {
            const { player, block, face, permutationToPlace, dimension } =
                event
            const offset = faceOffset.get(face)
            const newLocation = { x: block.location.x - offset.x, y: block.location.y - offset.y, z: block.location.z - offset.z }
            const newBlock = dimension.getBlock(newLocation)
            if (newBlock.hasTag('plant') || newBlock.typeId === 'minecraft:ladder' || newBlock.typeId === 'minecraft:cobweb' || newBlock.typeId === 'minecraft:tripwire_hook' || newBlock.typeId === 'minecraft:sea_pickle' || newBlock.typeId === 'minecraft:dead_bush' || newBlock.typeId === 'minecraft:yellow_flower' || newBlock.typeId === 'minecraft:poppy' || newBlock.typeId === 'minecraft:blue_orchid' || newBlock.typeId === 'minecraft:allium' || newBlock.typeId === 'minecraft:azure_bluet' || newBlock.typeId === 'minecraft:oxeye_daisy' || newBlock.typeId === 'minecraft:sunflower' || newBlock.typeId === 'minecraft:lilac' || newBlock.typeId === 'minecraft:rose_bush' || newBlock.typeId === 'minecraft:peony' || newBlock.typeId === 'minecraft:brown_mushroom' || newBlock.typeId === 'minecraft:red_mushroom' || newBlock.typeId === 'minecraft:hanging_roots' || newBlock.typeId === 'minecraft:glow_lichen' || newBlock.typeId === 'minecraft:azalia' || newBlock.typeId === 'minecraft:flowering_azalea' || newBlock.typeId === 'minecraft:big_dripleaf' || newBlock.typeId === 'minecraft:small_dripleaf_block' || newBlock.typeId === 'minecraft:pointed_dripstone' || newBlock.typeId === 'minecraft:reeds' || newBlock.typeId === 'minecraft:coral' || newBlock.typeId === 'minecraft:coral_fan' || newBlock.typeId === 'minecraft:spore_blossom' || newBlock.typeId === 'minecraft:vines' || newBlock.typeId === 'minecraft:weeping_vines' || newBlock.typeId === 'minecraft:twisting_vines' || newBlock.typeId === 'minecraft:sweet_berry_bush' || newBlock.typeId === 'minecraft:carrots' || newBlock.typeId === 'minecraft:potatoes' || newBlock.typeId === 'minecraft:beetroot' || newBlock.typeId === 'minecraft:wheat' || newBlock.typeId === 'minecraft:pumpkin_stem' || newBlock.typeId === 'minecraft:melon_stem' || newBlock.typeId === 'minecraft:bamboo' || newBlock.typeId === 'minecraft:bamboo_sapling' || newBlock.typeId === 'minecraft:moss_carpet' || newBlock.typeId === 'v360:infected_moss_carpet' || newBlock.typeId === 'minecraft:nether_wart' || newBlock.typeId === 'minecraft:waterlily' || newBlock.typeId === 'minecraft:cocoa' || newBlock.typeId === 'minecraft:redstone_wire' || newBlock.typeId === 'minecraft:frog_spawn' || newBlock.typeId === 'minecraft:chorus_flower' || newBlock.typeId === 'minecraft:chorus_plant' || newBlock.typeId === 'minecraft:scaffolding' || newBlock.typeId === 'minecraft:torchflower' || newBlock.typeId === 'minecraft:torflower_crop' || newBlock.typeId === 'minecraft:unlit_redstone_torch' || newBlock.typeId === 'minecraft:pitcher_plant' || newBlock.typeId === 'minecraft:pitcher_crop' || newBlock.typeId === 'minecraft:farmland' || newBlock.typeId === 'minecraft:grass_path' || newBlock.typeId === 'minecraft:nether_sprouts' || newBlock.typeId === 'minecraft:crimson_roots' || newBlock.typeId.includes('leaves') || newBlock.typeId.includes('carpet') || newBlock.typeId.includes('bud') || newBlock.typeId.includes('cluster') || newBlock.typeId.includes('fence_gate') || newBlock.typeId.includes('door') || newBlock.typeId.includes('fence') || newBlock.typeId.includes('torch') || newBlock.typeId.includes('lantern') || newBlock.typeId.includes('sign') || newBlock.typeId.includes('pane') || newBlock.typeId.includes('bar') || newBlock.typeId.includes('bars') || newBlock.typeId.includes('chest') || newBlock.typeId.includes('egg') || newBlock.typeId.includes('banner') || newBlock.typeId.includes('trapdoor') || newBlock.typeId.includes('wall') || newBlock.typeId.includes('bed') || newBlock.typeId.includes('candle') || newBlock.typeId.includes('campfire') || newBlock.typeId.includes('anvil') || newBlock.typeId.includes('coral_fan') || newBlock.typeId.includes('sapling') || newBlock.typeId.includes('rod') || newBlock.typeId.includes('tulip') || (newBlock.typeId.includes('slab') && !newBlock.typeId.includes('double')) || newBlock.typeId.includes('pot') || newBlock.typeId.includes('frame') || newBlock.typeId.includes('button') || newBlock.typeId.includes('pressure_plate') || newBlock.typeId.includes('rail')
            ) {
                event.cancel = true
            }
        }
    })
})

world.beforeEvents.worldInitialize.subscribe(initEvent => {
    initEvent.blockTypeRegistry.registerCustomComponent('v360:multi_destroy_lantern', {
        onTick({ block }) {
            const { x, y, z } = block.location
            if (block.hasTag('v360:up') && block.below().isAir) {
                block.dimension.runCommand(`setblock ${x} ${y} ${z} air [] destroy`)
            }
            else if (block.hasTag('v360:down') && block.above().isAir) {
                block.dimension.runCommand(`setblock ${x} ${y} ${z} air [] destroy`)
            }
        },
        beforeOnPlayerPlace: (event) => {
            const { player, block, face, permutationToPlace, dimension } =
                event
            const offset = faceOffset.get(face)
            const newLocation = { x: block.location.x - offset.x, y: block.location.y - offset.y, z: block.location.z - offset.z }
            const newBlock = dimension.getBlock(newLocation)
            if (newBlock.hasTag('plant') || newBlock.typeId === 'minecraft:ladder' || newBlock.typeId === 'minecraft:cobweb' || newBlock.typeId === 'minecraft:tripwire_hook' || newBlock.typeId === 'minecraft:sea_pickle' || newBlock.typeId === 'minecraft:dead_bush' || newBlock.typeId === 'minecraft:yellow_flower' || newBlock.typeId === 'minecraft:poppy' || newBlock.typeId === 'minecraft:blue_orchid' || newBlock.typeId === 'minecraft:allium' || newBlock.typeId === 'minecraft:azure_bluet' || newBlock.typeId === 'minecraft:oxeye_daisy' || newBlock.typeId === 'minecraft:sunflower' || newBlock.typeId === 'minecraft:lilac' || newBlock.typeId === 'minecraft:rose_bush' || newBlock.typeId === 'minecraft:peony' || newBlock.typeId === 'minecraft:brown_mushroom' || newBlock.typeId === 'minecraft:red_mushroom' || newBlock.typeId === 'minecraft:hanging_roots' || newBlock.typeId === 'minecraft:glow_lichen' || newBlock.typeId === 'minecraft:azalia' || newBlock.typeId === 'minecraft:flowering_azalea' || newBlock.typeId === 'minecraft:big_dripleaf' || newBlock.typeId === 'minecraft:small_dripleaf_block' || newBlock.typeId === 'minecraft:pointed_dripstone' || newBlock.typeId === 'minecraft:reeds' || newBlock.typeId === 'minecraft:coral' || newBlock.typeId === 'minecraft:coral_fan' || newBlock.typeId === 'minecraft:spore_blossom' || newBlock.typeId === 'minecraft:vines' || newBlock.typeId === 'minecraft:weeping_vines' || newBlock.typeId === 'minecraft:twisting_vines' || newBlock.typeId === 'minecraft:sweet_berry_bush' || newBlock.typeId === 'minecraft:carrots' || newBlock.typeId === 'minecraft:potatoes' || newBlock.typeId === 'minecraft:beetroot' || newBlock.typeId === 'minecraft:wheat' || newBlock.typeId === 'minecraft:pumpkin_stem' || newBlock.typeId === 'minecraft:melon_stem' || newBlock.typeId === 'minecraft:bamboo' || newBlock.typeId === 'minecraft:bamboo_sapling' || newBlock.typeId === 'minecraft:moss_carpet' || newBlock.typeId === 'v360:infected_moss_carpet' || newBlock.typeId === 'minecraft:nether_wart' || newBlock.typeId === 'minecraft:waterlily' || newBlock.typeId === 'minecraft:cocoa' || newBlock.typeId === 'minecraft:redstone_wire' || newBlock.typeId === 'minecraft:frog_spawn' || newBlock.typeId === 'minecraft:chorus_flower' || newBlock.typeId === 'minecraft:chorus_plant' || newBlock.typeId === 'minecraft:scaffolding' || newBlock.typeId === 'minecraft:torchflower' || newBlock.typeId === 'minecraft:torflower_crop' || newBlock.typeId === 'minecraft:unlit_redstone_torch' || newBlock.typeId === 'minecraft:pitcher_plant' || newBlock.typeId === 'minecraft:pitcher_crop' || newBlock.typeId === 'minecraft:farmland' || newBlock.typeId === 'minecraft:grass_path' || newBlock.typeId === 'minecraft:nether_sprouts' || newBlock.typeId === 'minecraft:crimson_roots' || newBlock.typeId.includes('leaves') || newBlock.typeId.includes('carpet') || newBlock.typeId.includes('bud') || newBlock.typeId.includes('cluster') || newBlock.typeId.includes('fence_gate') || newBlock.typeId.includes('door') || newBlock.typeId.includes('torch') || newBlock.typeId.includes('lantern') || newBlock.typeId.includes('sign') || newBlock.typeId.includes('pane') || newBlock.typeId.includes('bar') || newBlock.typeId.includes('bars') || newBlock.typeId.includes('chest') || newBlock.typeId.includes('egg') || newBlock.typeId.includes('banner') || newBlock.typeId.includes('trapdoor') || newBlock.typeId.includes('bed') || newBlock.typeId.includes('candle') || newBlock.typeId.includes('campfire') || newBlock.typeId.includes('anvil') || newBlock.typeId.includes('coral_fan') || newBlock.typeId.includes('sapling') || newBlock.typeId.includes('rod') || newBlock.typeId.includes('tulip') || (newBlock.typeId.includes('slab') && !newBlock.typeId.includes('double')) || newBlock.typeId.includes('pot') || newBlock.typeId.includes('frame') || newBlock.typeId.includes('button') || newBlock.typeId.includes('pressure_plate') || newBlock.typeId.includes('rail')
            ) {
                event.cancel = true
            }
        }
    })
})